/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.reader;

import filenet.vw.toolkit.design.visio.model.reader.VisioBufferedReader;
import filenet.vw.toolkit.design.visio.model.reader.VisioBufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Vector;

class VisioXMLParser {
    protected Vector m_pageFiles = new Vector();
    protected Vector m_mastersFiles = new Vector();
    protected Vector m_documentPropertiesFiles = new Vector();
    private StringBuffer m_xmlDec = new StringBuffer();
    private VisioBufferedReader m_bufferedReader = null;
    private int m_nPushBackCount = 0;
    private boolean m_bWrite = false;
    private VisioBufferedWriter m_bufferedWriter = null;

    public VisioXMLParser(Reader reader) {
        this.m_bufferedReader = new VisioBufferedReader(reader);
    }

    public void parseTag(int initState) throws IOException {
        int state = initState;
        int lastState = -1;
        char ch = '\u0000';
        StringBuffer tagName = new StringBuffer();
        block7: while (true) {
            int newState;
            if ((newState = VisioXMLParser.getNextState(state, '\u0000')) != -1) {
                lastState = state;
                state = newState;
                continue;
            }
            ch = this.getNextChar();
            lastState = state;
            state = VisioXMLParser.getNextState(state, ch);
            switch (state) {
                case -1: {
                    break;
                }
                case 2: {
                    char peek = (char)this.m_bufferedReader.peek();
                    if (lastState != 2) break;
                    tagName.append(ch);
                    if (peek != ' ' && peek != '/' && peek != '>') continue block7;
                    this.tagStart(tagName.toString());
                    break;
                }
                case 11: {
                    this.tagEnd(tagName.toString());
                    return;
                }
                case 10: {
                    this.pushback();
                    this.parseTag(2);
                    break;
                }
                case 3: 
                case 12: {
                    this.pushback();
                    this.parseDecTag(1);
                }
            }
        }
    }

    private void parseDecTag(int initState) throws IOException {
        int state = initState;
        char ch = '\u0000';
        StringBuffer sb = new StringBuffer("<");
        boolean isCData = false;
        while (true) {
            int newState;
            if ((newState = VisioXMLParser.getNextDecState(state, '\u0000')) != -1) {
                state = newState;
                continue;
            }
            ch = this.getNextChar();
            sb.append(ch);
            state = VisioXMLParser.getNextDecState(state, ch);
            switch (state) {
                case -1: {
                    break;
                }
                case 13: {
                    isCData = true;
                    break;
                }
                case 19: {
                    if (isCData) {
                        this.setCDataDeclaration(sb.toString());
                    } else {
                        this.declaration(sb.toString());
                    }
                    return;
                }
            }
        }
    }

    private void pushback() {
        ++this.m_nPushBackCount;
        this.m_bufferedReader.pushback();
    }

    private char getNextChar() throws IOException {
        char ch = (char)this.m_bufferedReader.read();
        if (this.m_nPushBackCount > 0) {
            --this.m_nPushBackCount;
        } else {
            this.charRead(ch);
        }
        return ch;
    }

    private static int getNextState(int state, char ch) {
        if (state == 1 && ch == '<') {
            return 2;
        }
        if (state == 1 && ch != '\u0000') {
            return 1;
        }
        if (state == 2 && (ch == '?' || ch == '!')) {
            return 3;
        }
        if (state == 2 && ch == '/') {
            return 9;
        }
        if (state == 2 && ch == ' ') {
            return 4;
        }
        if (state == 2 && ch == '>') {
            return 7;
        }
        if (state == 2 && ch != '\u0000') {
            return 2;
        }
        if (state == 3 && ch == '\u0000') {
            return 1;
        }
        if (state == 4 && ch == '\'') {
            return 5;
        }
        if (state == 4 && ch == '\"') {
            return 6;
        }
        if (state == 4 && ch == '>') {
            return 7;
        }
        if (state == 4 && ch == '/') {
            return 9;
        }
        if (state == 4 && ch != '\u0000') {
            return 4;
        }
        if (state == 5 && ch == '\'') {
            return 4;
        }
        if (state == 5 && ch != '\u0000') {
            return 5;
        }
        if (state == 6 && ch == '\"') {
            return 4;
        }
        if (state == 6 && ch != '\u0000') {
            return 6;
        }
        if (state == 7 && ch == '<') {
            return 8;
        }
        if (state == 7 && ch != '\u0000') {
            return 7;
        }
        if (state == 8 && (ch == '?' || ch == '!')) {
            return 12;
        }
        if (state == 8 && ch == '/') {
            return 9;
        }
        if (state == 8 && ch != '\u0000') {
            return 10;
        }
        if (state == 9 && ch == '>') {
            return 11;
        }
        if (state == 9 && ch != '\u0000') {
            return 9;
        }
        if (state == 10 && ch == '\u0000') {
            return 7;
        }
        if (state == 12 && ch == '\u0000') {
            return 7;
        }
        return -1;
    }

    private static int getNextDecState(int state, char ch) {
        if (state == 1 && ch == '!') {
            return 2;
        }
        if (state == 1 && ch != '\u0000') {
            return 16;
        }
        if (state == 2 && ch == '-') {
            return 3;
        }
        if (state == 2 && ch == '[') {
            return 7;
        }
        if (state == 2 && ch != '\u0000') {
            return 16;
        }
        if (state == 3 && ch == '-') {
            return 4;
        }
        if (state == 3 && ch != '\u0000') {
            return 16;
        }
        if (state == 4 && ch == '-') {
            return 5;
        }
        if (state == 4 && ch != '\u0000') {
            return 4;
        }
        if (state == 5 && ch == '-') {
            return 6;
        }
        if (state == 5 && ch != '\u0000') {
            return 4;
        }
        if (state == 6 && ch == '>') {
            return 19;
        }
        if (state == 6 && ch != '\u0000') {
            return 4;
        }
        if (state == 7 && ch == 'C') {
            return 8;
        }
        if (state == 7 && ch != '\u0000') {
            return 16;
        }
        if (state == 8 && ch == 'D') {
            return 9;
        }
        if (state == 8 && ch != '\u0000') {
            return 16;
        }
        if (state == 9 && ch == 'A') {
            return 10;
        }
        if (state == 9 && ch != '\u0000') {
            return 16;
        }
        if (state == 10 && ch == 'T') {
            return 11;
        }
        if (state == 10 && ch != '\u0000') {
            return 16;
        }
        if (state == 11 && ch == 'A') {
            return 12;
        }
        if (state == 11 && ch != '\u0000') {
            return 16;
        }
        if (state == 12 && ch == '[') {
            return 13;
        }
        if (state == 12 && ch != '\u0000') {
            return 16;
        }
        if (state == 13 && ch == ']') {
            return 14;
        }
        if (state == 13 && ch != '\u0000') {
            return 13;
        }
        if (state == 14 && ch == ']') {
            return 15;
        }
        if (state == 14 && ch != '\u0000') {
            return 13;
        }
        if (state == 15 && ch == '>') {
            return 19;
        }
        if (state == 15 && ch != '\u0000') {
            return 13;
        }
        if (state == 16 && ch == '>') {
            return 19;
        }
        if (state == 16 && ch == '\"') {
            return 17;
        }
        if (state == 16 && ch == '\'') {
            return 18;
        }
        if (state == 16 && ch != '\u0000') {
            return 16;
        }
        if (state == 17 && ch == '\"') {
            return 16;
        }
        if (state == 17 && ch != '\u0000') {
            return 17;
        }
        if (state == 18 && ch == '\'') {
            return 16;
        }
        if (state == 18 && ch != '\u0000') {
            return 18;
        }
        return -1;
    }

    private void charRead(char ch) {
        if (this.m_bWrite) {
            this.write(ch);
        }
    }

    private void setCDataDeclaration(String cData) {
    }

    private void declaration(String dec) {
        this.m_xmlDec.append(dec + "\r\n");
    }

    private void tagStart(String tag) {
        File tmpFile = null;
        if (tag.equals("Page") || tag.equals("DocumentProperties") || tag.equals("Masters")) {
            if (this.m_bufferedWriter != null) {
                return;
            }
            try {
                tmpFile = File.createTempFile(tag, null);
                this.m_bufferedWriter = new VisioBufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF8"));
                this.m_bWrite = true;
                this.write(this.m_xmlDec.toString());
                this.write("<VisioDocument>\r\n");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (tag.equals("Page")) {
            this.m_pageFiles.add(tmpFile);
            this.write("<Pages>");
            this.write("<" + tag);
        } else if (tag.equals("DocumentProperties")) {
            this.m_documentPropertiesFiles.add(tmpFile);
            this.write("<" + tag);
        } else if (tag.equals("Masters")) {
            this.m_mastersFiles.add(tmpFile);
            this.write("<" + tag);
        }
    }

    private void tagEnd(String tag) {
        try {
            if (tag.equals("Page")) {
                this.write("</Pages>");
            }
            if (tag.equals("Page") || tag.equals("DocumentProperties") || tag.equals("Masters")) {
                this.write("</VisioDocument>");
                this.m_bWrite = false;
                this.m_bufferedWriter.flush();
                this.m_bufferedWriter.close();
                this.m_bufferedWriter = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void write(char ch) {
        try {
            this.m_bufferedWriter.write(ch);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void write(String str) {
        for (int nIndex = 0; nIndex < str.length(); ++nIndex) {
            this.write(str.charAt(nIndex));
        }
    }
}

